#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Tutorial #2 - Street LightsMod01.fsh   by   DGMKPixy 
//https://www.shadertoy.com/view/XfSfRD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Define la distancia que hay entre la camara y la pantalla.
#define CAMERA_SCREEN_DIST 2.

vec4 Noise4(float t, vec4 seed)
{
    return fract(sin(t * vec4(6543.,1234.,9642.,3312.))*seed); 
}


float Noise(float t, float seed)
{
    return fract(sin(t * 6543.)*seed); 
}

struct Ray
{
    vec3 origin;
    vec3 direction;
};

Ray GetRay(vec2 uv, vec3 cameraOrigin, vec3 lookat, float zoom)
{
    // vector FRENTE de la camara
    vec3 F = normalize(lookat - cameraOrigin);
    // Vector DERECHA de la camara
    vec3 R = cross(vec3(0.,1.,0.), F);
    // Vector UP de la camara
    vec3 U = cross(F, R);
        
    // Ahora tenemos que saber cual es el centro de la pantalla. El centro de la
    // pantalla será un punto resultante de la suma del origen más el vector FRENTE por
    // el zoom.
    vec3 centerScreen = cameraOrigin + F * zoom;
    // Con el centro, podemos calcular donde está el punto "i". Este punto es la posición
    // uv del pixel situado RIGHT veces en el eje x y UP veces en el eje y desde el centro
    vec3 i = centerScreen + uv.x*R + uv.y*U;
    // calculamos la dirección del rayo
    vec3 rayDirection = normalize(i - cameraOrigin);
    
    Ray r;
    r.origin = cameraOrigin;
    r.direction = rayDirection;
    return r;
}

vec3 ClosestPointInRayFromPoint(Ray r, vec3 point)
{
    return r.origin + max(0., dot(point - r.origin, r.direction))*r.direction;
}

float DistRay(Ray r, vec3 point)
{
    return length(point-ClosestPointInRayFromPoint(r, point));
}

float DistLine(vec3 ro, vec3 rd, vec3 p)
{
    return length(cross((p-ro),rd)) / length(rd); 
}



float DrawPoint(vec3 ro, vec3 rd, vec3 p)
{
    float d = DistLine(ro, rd, p);
    d = smoothstep(.06,.05,d);
    return d;
}

float Bokeh(Ray r, vec3 point, float size, float blur)
{
    float d = DistRay(r, point);
    size *= length(point);
    float c = smoothstep(size,size*(1.-blur),d);
    c *= mix(.7,1.,smoothstep(size*.8,size,d));
    return c;
}

vec3 StreetLights(Ray r, float t)
{
    float side = step(r.direction.x,0.);
    r.direction.x = abs(r.direction.x);
    float s = .1;
    float m = 0.;
    for(float i = 0.; i < 1.; i+=s)
    {
        float ti = fract(t + i + side*s*.5);
        vec3 p = vec3(2.,2.,100.-(ti)*100.);//vec3(sin(iTime),0.,2. + (2.*cos(iTime)));
        m += Bokeh(r, p, .05,.1)*ti*ti*ti;
    }
    
    return m * vec3(1.,.7,.3);
}

vec3 EnvironmentLights(Ray r, float t)
{
    float side = step(r.direction.x,0.);
    r.direction.x = abs(r.direction.x);
    float s = 1./10.;
    vec3 c = vec3(0.);
    for(float i = 0.; i < 1.; i+=s)
    {
        float ti = fract(t + i + side*s*.5);
        float fade = ti*ti*ti; 
        vec4 n = Noise4(i + side*100., vec4(1232., 481., 241., 544.));
        
        float occlusion = sin(ti*6.28*10.*n.x) * .5 + .5; //2*PI
        fade = occlusion;
        vec3 col = n.wzy;
        
        float x = mix(2.5,10.,n.x);
        float y = mix(.1,1.5,n.y);
        
        vec3 p = vec3(x,y,50.-(ti)*50.);//vec3(sin(iTime),0.,2. + (2.*cos(iTime)));
        c += Bokeh(r, p, .05,.1)*fade*col*.5;
    }
    
    return c;
}

vec3 HeadLights(Ray r, float t)
{
    t *= 2.; // así parece que los coches van más rápido.

    float carWidth = .25;
    float carWidth2 = carWidth*1.2;
    float s = 1. / 30.;
    float m = 0.;
    for(float i = 0.; i < 1.; i+=s)
    {
        float n = Noise(i, 9234.); // i es el coche
        
        if(n > .1) continue;
        
        // ti es la distancia normalizada entre el principio de la luz y el final
        float ti = fract(t + i);// + side*s*.5);
        float fade = ti*ti*ti*ti*ti; // Cuanto más se eleve ti, mayor es el fade en el
                                     // punto de origen.
        float z = 100.-(ti)*100.;
        float focus = smoothstep(.9,1.,ti);
        
        float size = mix(.05, .03, focus);
        
        m += Bokeh(r, vec3(-1.-carWidth,.15,z), size,.1)*fade;
        m += Bokeh(r, vec3(-1.+carWidth,.15,z), size,.1)*fade;
        m += Bokeh(r, vec3(-1.-carWidth2,.15,z), size,.1)*fade;
        m += Bokeh(r, vec3(-1.+carWidth2,.15,z), size,.1)*fade;
        
        float ref = 0.;
        vec3 head3 = vec3(-1.-carWidth2,-.15,z);//vec3(sin(iTime),0.,2. + (2.*cos(iTime)));
        vec3 head4 = vec3(-1.+carWidth2,-.15,z);//vec3(sin(iTime),0.,2. + (2.*cos(iTime)));
        ref += Bokeh(r, head3, size*3.,1.)*fade;
        ref += Bokeh(r, head4, size*3.,1.)*fade;
        
        m+=ref*focus;
    }
    
    return m * vec3(.9,.9,1.);
}


vec3 TailLights(Ray r, float t)
{
    t *= .25; // así parece que los coches van más lento.

    float carWidth = .25;
    float carWidth2 = carWidth*1.2;
    float s = 1. / 15.; // Menos coches que en head
    float m = 0.;
    for(float i = 0.; i < 1.; i+=s)
    {
        float n = Noise(i, 6789.); // i es el coche
        
        if(n > .5) continue; // Pero más probable que aparezcan.
        
        float lane = step(.1,n); // 0 para el carril izq y 1 para el derecho.
        
        // ti es la distancia normalizada entre el principio de la luz y el final
        float ti = fract(t + i);// + side*s*.5);
        float fade = ti*ti*ti*ti*ti; // Cuanto más se eleve ti, mayor es el fade en el
                                     // punto de origen.
        float z = 100.-(ti)*100.;
        float lineShift = smoothstep(1.,.92,ti);
        float x = 1.5-lane * lineShift;
        float focus = smoothstep(.9,1.,ti);
        
        float size = mix(.05, .03, focus);
        
        // Cuando el sin de menos que 0, entonces valdrá 0 por el step, y cuando sea mayor,
        // valdrá 1.
        float blink = step(0.,sin(t*1000.)) * 5. * lane * step(.92,ti); // Esto provoca que vaya de 0 a 1 muy rápido
        float blinkerSize = size*.4;
        
        m += Bokeh(r, vec3(x-carWidth,.15,z), size,.1)*fade;
        m += Bokeh(r, vec3(x+carWidth,.15,z), size,.1)*fade;
        m += Bokeh(r, vec3(x-carWidth2,.15,z), size,.1)*fade;
        m += Bokeh(r, vec3(x+carWidth2,.15,z), size,.1)*fade*(1.+blink);  
        
        float ref = 0.;
        vec3 head3 = vec3(x-carWidth2,-.15,z);//vec3(sin(iTime),0.,2. + (2.*cos(iTime)));
        vec3 head4 = vec3(x+carWidth2,-.15,z);//vec3(sin(iTime),0.,2. + (2.*cos(iTime)));
        ref += Bokeh(r, head3, size*4.,1.)*fade;
        ref += Bokeh(r, head4, size*4.,1.)*fade*(1.+blink*.1);
        
        m+=ref*focus;
    }
    
    // Sobresaturamos el color rojo y hacemos muy pequeño el azul. Asi, cuando arriba
    // hacemos esto:
    //
    // blink = step(0.,sin(t*1000.))*5.
    // 
    // y multiplicamos el 5., estamos aumentando la instensidad, quedando el color con blink:
    // (5.,.5,.15) ó (1.,.5,.15)
    return m * vec3(1.,.1,.03); 
}

// Devuelve la distorsion de los uvs para hacer la lluvia
vec2 Rain(vec2 uv, float t)
{
    t*=40.;
    vec2 aspectRatio = vec2(3.,1.);
    vec2 st = uv*aspectRatio;
    vec2 id = floor(st);
    st.y += t*.2;
    float n = fract(sin(id.x*76.781) * 822.9);
    st.y += n;
    uv.y += n;
    
    id = floor(st);
    st = fract(st)-.5; // -.5 porque así centramos las UVs en cada recruado.
    
    t += fract(sin(id.x*532.781+id.y*84.56) * 82.9)*3.1416*5.;
    
    //float x = fract(cos(id.y*362.781)*232.25)*0.3;
    float x = sin(id.x*342.71+id.y*114.56);
    float y = -sin(t+sin(t+sin(t)*.5))*.4;
    vec2 position = vec2(x*.3,y);
    
    vec2 opacity1 = (st-position)/aspectRatio;
    float d = length(opacity1);
    float m1 = smoothstep(.08, .0, d);
    
    uv.x += -x*.3/length(aspectRatio); // Ajustamos el aspect ratio para las gotas.
    
    vec2 opacity2 = (fract(uv*vec2(1.,2.)*aspectRatio.x)-.5)/vec2(1.,2.);
    d = length(opacity2);
    float m2 = smoothstep(.3*(-st.y+.5), .0, d)*smoothstep(.1,-.1,y-st.y);
    
    //if(st.x > .46 || st.y > .49) m1 = 1.;
    vec2 result = vec2(m1*opacity1*30. + m2*opacity2*20.);
    return result;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 m = iMouse.xy/iResolution.xy;
    m -= .5;
    vec2 uv = fragCoord/iResolution.xy;
    uv -= .5;
    uv.x *= iResolution.x/iResolution.y; 

    vec3 cameraOrigin = vec3(0.5,.6,0.);
    //vec3 lookat = vec3(m.x,m.y+.2,1.);    
    vec3 lookat = vec3(0.5,.6,8.);    
    float zoom = 2.;

    float t = iTime*.05+m.x;
    vec2 rainDistorsion = Rain(uv*15., t*.7)*.3;
    rainDistorsion += Rain(uv*.6, t*2.)*.1;

    rainDistorsion += Rain(uv*4., t)*.1;

    uv.x += sin(uv.y*100.)*.004;
    uv.y += sin(uv.x*170.)*.002;
    // creamos un Ray para cada uv.
    //Reflexion
    //Ray r = GetRay(uv-rainDistorsion, cameraOrigin, lookat, zoom);
    //Refraccion
    Ray r = GetRay(uv-rainDistorsion, cameraOrigin, lookat, zoom);
        
    vec3 c = StreetLights(r, t);
    c += HeadLights(r,t);
    c += TailLights(r,t);
    c += EnvironmentLights(r,t);
    
    c += (r.direction.y+.25) * vec3(.2,.1,.5);
    
    /*
    DrawPoint(cameraOrigin, r.direction, p+vec3(0,0,0.));
    d += DrawPoint(cameraOrigin, r.direction, p+vec3(0.,0.,1.));
    d += DrawPoint(cameraOrigin, r.direction, p+vec3(0.,1.,0.));
    d += DrawPoint(cameraOrigin, r.direction, p+vec3(0.,1.,1.));
    d += DrawPoint(cameraOrigin, r.direction, p+vec3(1.,0.,0.));
    d += DrawPoint(cameraOrigin, r.direction, p+vec3(1.,0.,1.));
    d += DrawPoint(cameraOrigin, r.direction, p+vec3(1.,1.,0.));
    d += DrawPoint(cameraOrigin, r.direction, p+vec3(1.,1.,1.));
    */
    // Time varying pixel color
    vec4 col = vec4(c,1.);
    
    //col += vec3(rainDistorsion,0.);

    // Output to screen
    fragColor = vec4(col);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

